/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import javax.annotation.Nonnull;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.miner.MinerFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class MinerMaterialFilter
extends MinerFilter<MinerMaterialFilter>
implements IMaterialFilter<MinerMaterialFilter> {
    private ItemStack materialItem = ItemStack.f_41583_;

    public MinerMaterialFilter(ItemStack item) {
        this.materialItem = item;
    }

    public MinerMaterialFilter() {
    }

    public MinerMaterialFilter(MinerMaterialFilter filter) {
        super(filter);
        this.materialItem = filter.materialItem.m_41777_();
    }

    @Override
    public boolean canFilter(BlockState state) {
        return state.m_60767_() == this.getMaterial();
    }

    @Override
    public boolean hasBlacklistedElement() {
        return !this.materialItem.m_41619_() && this.materialItem.m_41720_() instanceof BlockItem && TagCache.materialHasMinerBlacklisted(this.materialItem);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        this.materialItem.m_41739_(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        this.materialItem = ItemStack.m_41712_((CompoundTag)nbtTags);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.m_130055_(this.materialItem);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.materialItem = dataStream.m_130267_();
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + this.materialItem.hashCode();
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) return false;
        if (!(o instanceof MinerMaterialFilter)) return false;
        MinerMaterialFilter filter = (MinerMaterialFilter)o;
        if (!filter.materialItem.m_41656_(this.materialItem)) return false;
        return true;
    }

    @Override
    public MinerMaterialFilter clone() {
        return new MinerMaterialFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_MATERIAL_FILTER;
    }

    @Override
    @Nonnull
    public ItemStack getMaterialItem() {
        return this.materialItem;
    }

    @Override
    public void setMaterialItem(@Nonnull ItemStack stack) {
        this.materialItem = stack;
    }
}

